/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.dynamicpack;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends DynClientResourcesProvider {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(ImmersiveWeathering.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).generateDebugResources = PlatformHelper.isDev() || CommonConfigs.DEBUG_RESOURCES.get() != false;
    }

    public Logger getLogger() {
        return ImmersiveWeathering.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void generateStaticAssetsOnStartup(class_3300 manager) {
        StaticResource leafParticle = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.PARTICLES.getPath(ImmersiveWeathering.res("oak_leaf")));
        ModParticles.FALLING_LEAVES_PARTICLES.forEach((leafType, particle) -> {
            String particleId = class_2378.field_11141.method_10221(particle).method_12832();
            try {
                this.addSimilarJsonResource(manager, leafParticle, "oak_leaf", particleId);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Particle for {} : {}", particle, (Object)ex);
            }
        });
        StaticResource lpBlockState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        StaticResource lpModel1 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height1")));
        StaticResource lpModel2 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height2")));
        StaticResource lpModel4 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height4")));
        StaticResource lpModel6 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height6")));
        StaticResource lpModel8 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height8")));
        StaticResource lpModel10 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height10")));
        StaticResource lpModel12 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height12")));
        StaticResource lpModel14 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height14")));
        StaticResource lpModel16 = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height16")));
        StaticResource lpItemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        ModBlocks.LEAF_PILES.forEach((leafType, pile) -> {
            if (leafType.isVanilla()) {
                return;
            }
            String path = leafType.getNamespace() + "/" + leafType.getTypeName();
            String id = path + "_leaf_pile";
            try {
                this.addSimilarJsonResource(manager, lpBlockState, "oak_leaf_pile", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile blockstate definition for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                this.addSimilarJsonResource(manager, lpItemModel, "oak_leaf_pile", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile item model for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                class_2960 leavesTexture;
                try {
                    leavesTexture = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)leafType.leaves, s -> true);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Failed to find texture for Leaf Pile {}, using oak one instead", (Object)pile);
                    leavesTexture = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)class_2246.field_10503, s -> true);
                }
                this.addLeafPilesModel(Objects.requireNonNull(lpModel1), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel2), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel4), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel6), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel8), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel10), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel12), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel14), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel16), id, leavesTexture);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile model for {} : {}", (Object)pile, (Object)ex);
            }
        });
        StaticResource itemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(ImmersiveWeathering.res("oak_bark")));
        ModItems.BARK.forEach((woodType, bark) -> {
            if (!woodType.isVanilla()) {
                String id = Utils.getID((class_1792)bark).method_12832();
                try {
                    this.addSimilarJsonResource(manager, itemModel, "oak_bark", id);
                }
                catch (Exception ex) {
                    this.getLogger().error("Failed to generate Bark item model for {} : {}", bark, (Object)ex);
                }
            }
        });
    }

    public void addLeafPilesModel(StaticResource resource, String id, class_2960 texturePath) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        String path = resource.location.method_12832().replace("oak_leaf_pile", id);
        string = string.replace("immersive_weathering:block/light_oak_leaves", texturePath.toString());
        string = string.replace("immersive_weathering:block/medium_oak_leaves", texturePath.toString());
        string = string.replace("heavy_oak_leaves", id.replace("/", "/heavy_"));
        class_2960 newRes = ImmersiveWeathering.res(path);
        ((DynamicTexturePack)this.dynamicPack).addBytes(newRes, string.getBytes(), ResType.GENERIC);
    }

    public void regenerateDynamicAssets(class_3300 manager) {
        TextureImage template;
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)ImmersiveWeathering.res("particle/oak_leaf_0"));
            try (TextureImage template1 = TextureImage.open((class_3300)manager, (class_2960)ImmersiveWeathering.res("particle/oak_leaf_1"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                Respriter respriter1 = Respriter.of((TextureImage)template1);
                ModParticles.FALLING_LEAVES_PARTICLES.forEach((type, particle) -> {
                    if (type.isVanilla()) {
                        return;
                    }
                    String path = type.getNamespace() + "/" + type.getTypeName();
                    try (TextureImage baseTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)type.leaves));){
                        TextureImage newImage;
                        Palette targetPalette;
                        class_2960 textureRes = ImmersiveWeathering.res(String.format("particle/%s_leaf_0", path));
                        if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                            targetPalette = Palette.fromImage((TextureImage)baseTexture);
                            newImage = respriter.recolor(targetPalette);
                            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                        }
                        if (!this.alreadyHasTextureAtLocation(manager, textureRes = ImmersiveWeathering.res(String.format("particle/%s_leaf_1", path)))) {
                            targetPalette = Palette.fromImage((TextureImage)baseTexture);
                            newImage = respriter1.recolor(targetPalette);
                            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Fail to generate Leaf Particle texture for type {} : {}", type, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Leaf Particle texture : ", (Throwable)ex);
        }
        ModBlocks.LEAF_PILES.forEach((type, pile) -> {
            if (type.isVanilla()) {
                return;
            }
            String path = type.getNamespace() + "/heavy_" + type.getTypeName() + "_leaf_pile";
            try (TextureImage baseTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)type.leaves));){
                class_2960 textureRes = ImmersiveWeathering.res(String.format("block/%s", path));
                if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                    Palette targetPalette = Palette.fromImage((TextureImage)baseTexture);
                    if (targetPalette.getDarkest().occurrence > 5) {
                        targetPalette.increaseDown();
                    }
                    PaletteColor dark = targetPalette.getDarkest();
                    baseTexture.removeAlpha(dark.value());
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, baseTexture);
                }
            }
            catch (Exception ex) {
                this.getLogger().error("Could not generate heavy leaf pile texture for type {}", type, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)ImmersiveWeathering.res("item/bark_template"));
            try {
                ModItems.BARK.forEach((type, bark) -> {
                    if (type.isVanilla()) {
                        return;
                    }
                    class_2960 textureRes = ImmersiveWeathering.res("item/" + Utils.getID((class_1792)bark).method_12832());
                    if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        try (TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)type.log, s -> !s.contains("top")));){
                            Palette palette = Palette.fromImage((TextureImage)logTexture);
                            palette.increaseDown();
                            PaletteColor dark = palette.getDarkest();
                            assert (template.imageWidth() <= logTexture.imageWidth() && template.imageHeight() <= logTexture.imageHeight());
                            TextureImage newImage = template.makeCopy();
                            class_1011 logImage = logTexture.getImage();
                            newImage.forEachFrame((i, x, y) -> {
                                class_1011 image = newImage.getImage();
                                int darkBorder = image.method_4315(x.intValue(), y.intValue());
                                if (darkBorder == -1) {
                                    image.method_4305(x.intValue(), y.intValue(), class_1011.method_24031((int)0, (int)0, (int)0, (int)0));
                                } else if (class_1011.method_24030((int)darkBorder) == 0) {
                                    image.method_4305(x.intValue(), y.intValue(), logImage.method_4315(x.intValue(), y.intValue()));
                                } else {
                                    image.method_4305(x.intValue(), y.intValue(), dark.value());
                                }
                            });
                            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to find log texture for bark {}", type, (Object)ex);
                        }
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Could not generate any Bark texture : ", (Throwable)e);
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModItems.BARK.forEach((type, bark) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.immersive_weathering.bark", (BlockType)type, (class_1792)bark));
        ModBlocks.LEAF_PILES.forEach((type, leaf) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block.immersive_weathering.leaf_pile", (BlockType)type, (class_2248)leaf));
    }
}

